# Personalizzare una form a run-time

Le form possono essere modificate (nel loro aspetto visivo) normalmente andando a modificare il codice html/css/php presente all'interno delle stesse.

Con questa nuova funzionalità si può modificarne l'aspetto anche a run-time ovvero mentre essa è in esecuzione.

# Prerequisiti

N.B. - la form deve essere già predisposta per tale funzionalità. Ogni coppia di label/campo deve essere inserito dentro un div con id="row". Inoltre la funzionalità non deve essere attivata per i campi che sono obbligatori.

All'interno del modulo
  ```
  <form ...></form>
  ```
  che si vuole personalizzare si deve:

* aggiungere il seguente codice html

  ```
  <script type="text/javascript" src="../../library/IER/IERincludeExcludeRows.js"></script>
  
  <input type="hidden" id="IERincludeExcludeRowsInput" name="IERincludeExcludeRowsInput" />
  
  <div id="IERenableIncludeExcludeRows" title="Personalizza videata" onclick="enableIncludeExcludeRows()"></div>
  <a target="_blank" href="../wiki/999%20-%20Sviluppo%20del%20gestionale/99..%20Personalizzare%20una%20form%20a%20run-time.md"><div id="IERhelpIncludeExcludeRows" title="Aiuto"></div></a>
  <div id="IERsaveIncludeExcludeRows" title="Nessuna modifica fatta" onclick="saveIncludeExcludeRows()"></div>
  <div id="IERresetIncludeExcludeRows" title="Ripristina"></div>
  
  ```

  Questo permette di includere lo script che contiene le funzioni per la gestione della funzionalità, un campo nascosto per usi interni e quattro div per gestire i pulsanti per 'Personalizza', 'Aiuto', 'Salva impostazioni' e 'Ripristina'.

  Attenzione -  Se il modulo php viene richiamato anche in modale (da altri moduli) la funzionalità non deve essere attivata quindi le righe andranno inserite nella condizione diverso da modale. Normalmente questa condizione viene espressa dal seguente codice

  ```
  if ($modal === false) { ...
  ```

* sostituire i div
    ```
    <div class="row">
    ```

  con un div di questo tipo

  ```
  <div id="catMer" class="row IERincludeExcludeRow">
  ```

  che abbia un id che identifichi il campo in maniera univoca in tutto il codice del modulo ed aggiungere la nuova classe "IERincludeExcludeRow"

# Personalizzare una form a run-time (lato utente) 

Le form possono essere modificate (nel loro aspetto visivo) normalmente andando a modificare il codice html/css/php presente all'interno delle stesse.

Con questa nuova funzionalità si può modificarne l'aspetto anche a run-time ovvero mentre essa è in esecuzione.

# Come utilizzare la nuova funzionalità a run-time (lato utente)

All'apertura di un form (quando previsto) si potrà attivare la funzione di 'Personalizza finestra' richiamabile tramite la rotellina <i class="glyphicon glyphicon-cog"></i> situata in alto a sinistra

<center>![Personalizza finestra (lato utente)](_contenuti/immagini/IER_personalizza_finestra_lato_utente.jpg)</center>

l'evidenziazione in rosso della rotellina indica che la form è già stata personalizzata precedentemente. Tramite la funzione di 'Aiuto' richiamabile tramite il punto interrogativo <span style="color:#72afd2"><i class="glyphicon glyphicon-question-sign"></i></span> situato a destra della rotellina si apre questa guida.

Dopo che la funzione di personalizzazione viene attivata verranno rese disponibili le funzioni di 'Salva nuove impostazioni' richiamabile tramite il dischetto <i class="glyphicon glyphicon-floppy-disk"></i> situato 
alla destra del punto interrogativo e di 'Ripristina' richiamabile tramite la gomma <i class="glyphicon glyphicon-erase"></i> situato alla destra del dischetto.
Se il dischetto è in nero non sono state apportate modifiche e non c'è nulla da salvare. Se la gomma è disattivata (in grigio chiaro) allora non c'è nulla da ripristinare.

Alla sinistra di ogni riga (predisposta alla gestione) viene posizionato il simbolo dell'occhio aperto <span style="color:#03ab00"><i class="glyphicon glyphicon-eye-open"></i></span> nel caso la riga debba essere visibile (di default tutte le righe all'inizio sono visibili) o il simbolo dell'occhio chiuso <span style="color:red"><i class="glyphicon glyphicon-eye-close"></i></span> nel caso la riga non debba essere visualizzata.

<center>![Modifica a run-time (lato utente)](_contenuti/immagini/IER_modifica_a_runtime_lato_utente.jpg)</center>

Una volta fatte le dovute personalizzazioni si può decidere di salvarle cliccando sul dischetto in rosso oppure uscire dalla gestione ripremendo nuovamente la rotellina ed eventualmente non confermare le personalizzazioni fatte.
Inoltre si possono ripristinare tutte le personalizzazioni fatte tramite l'apposita funzione gomma.

# Esempio pratico realizzato sul modulo php admin_artico.php (Inserisci/Modifica articolo)

    ```
    <?php
    /*
      --------------------------------------------------------------------------
      GAzie - Gestione Azienda

    ...

    */

    ...

    if ($modal === false) {
    		<!--+ DC - 06/02/2019 -->
    		<script type="text/javascript" src="../../library/IER/IERincludeExcludeRows.js"></script>

    		<input type="hidden" id="IERincludeExcludeRowsInput" name="IERincludeExcludeRowsInput" />
			
			<div id="IERenableIncludeExcludeRows" title="Personalizza videata" onclick="enableIncludeExcludeRows()"></div>
			<a target="_blank" href="../wiki/999%20-%20Sviluppo%20del%20gestionale/99..%20Personalizzare%20una%20form%20a%20run-time.md"><div id="IERhelpIncludeExcludeRows" title="Aiuto"></div></a>
			<div id="IERsaveIncludeExcludeRows" title="Nessuna modifica fatta" onclick="saveIncludeExcludeRows()"></div>
    		<div id="IERresetIncludeExcludeRows" title="Ripristina"></div>
			<!--- DC - 06/02/2019 -->
        <?php
        if ($toDo == 'insert') {

    ...

    // campo obbligatorio - riga non predisposta
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label for="descri" class="col-sm-4 control-label"><?php echo $script_transl['descri']; ?></label>
                <input class="col-sm-8" type="text" value="<?php echo $form['descri']; ?>" name="descri" maxlength="255" />
            </div>
        </div>
    </div><!-- chiude row  -->
    <!--+ DC - 06/02/2019 div class="row" --->
    <div id="catMer" class="row IERincludeExcludeRow">
        <div class="col-md-12">
            <div class="form-group">
                <label for="catmer" class="col-sm-4 control-label"><?php echo $script_transl['catmer']; ?></label>
    <?php
    $gForm->selectFromDB('catmer', 'catmer', 'codice', $form['catmer'], false, 1, ' - ', 'descri', '', 'col-sm-8', null, 'style="max-width: 250px;"');
    ?>
            </div>
        </div>
    </div><!-- chiude row  -->

    ...

    ?>
    ```
